import { callMcpApi } from "./httpClient.js";

let authenticated = false;
let cachedUserId: string | null = null;

export function isAuthenticated(): boolean {
  return authenticated;
}

export function getUserId(): string {
  if (!cachedUserId) {
    throw new Error("API 키 검증이 완료되지 않았습니다.");
  }
  return cachedUserId;
}

export async function ensureApiKeyVerified(): Promise<void> {
  if (authenticated) {
    return;
  }

  const data = await callMcpApi<{
    success: boolean;
    userId: string;
    message?: string;
    error?: string;
  }>("verify-api-key", { method: "POST" });

  if (!data?.success) {
    throw new Error(data?.error || "API 키 검증에 실패했습니다.");
  }

  cachedUserId = data.userId;
  authenticated = true;
}
