import type { CharacterCard, SituationImage } from "./types.js";
/**
 * Validates and normalizes a character card with default values
 */
export declare function normalizeCharacterCard(input: Partial<CharacterCard>): CharacterCard;
/**
 * Generate default situation images for a starting set
 */
export declare function generateDefaultSituationImages(setIndex: number): SituationImage[];
/**
 * Generate default keyword notes
 */
export declare function generateDefaultKeywordNotes(): {
    name: string;
    prompt: string;
    keywords: string[];
    targets: number[];
}[];
