/**
 * Character card types matching the Ssalmuk backend schema
 */
export type TargetAudience = "all" | "male" | "female";
export type AudienceTier = "allAges" | "adultsOnly";
export type NovelAiAspect = "square" | "portrait" | "landscape";
export type GenreName = "로맨스" | "로판" | "SF/판타지" | "일상/현대" | "무협" | "시대" | "BL" | "GL" | "기타";
export interface KeywordNote {
    name: string;
    prompt: string;
    keywords: string[];
    targets?: number[];
}
export interface InitialMessage {
    id?: string;
    role: "assistant" | "user" | "system";
    text: string;
}
export interface SituationImage {
    imageUrl?: string;
    keyword?: string;
    situation?: string;
    aspect?: NovelAiAspect;
    prompt?: string;
}
export interface StartingSet {
    id?: string;
    name: string;
    situationPrompt?: string;
    playGuide?: string;
    initialMessages: InitialMessage[];
    replySuggestions?: string[];
    situationImages?: SituationImage[];
}
export interface StartingSetImage {
    id?: string;
    keyword?: string | null;
    situation?: string | null;
    imageUrl?: string | null;
}
export interface PublicStartingSet {
    id?: string;
    baseSetId?: string | null;
    name?: string | null;
    situationPrompt?: string | null;
    playGuide?: string | null;
    includeMediaInPrompt?: boolean | null;
    initialMessages?: InitialMessage[];
    replySuggestions?: string[];
    situationImages?: StartingSetImage[];
}
export interface SituationPrompt {
    imageUrl?: string;
    prompt: string;
    aspect?: NovelAiAspect;
    targets?: number[];
}
export interface CommandPreset {
    id?: string;
    name?: string;
    command: string;
    description?: string;
    instruction: string;
}
export interface AdvancedImageSettings {
    enabled?: boolean;
    model?: string;
    sampler?: string;
    cfgScale?: number;
    steps?: number;
    alwaysAddedPrompt?: string;
    negativePrompt?: string;
    profilePrompt?: string;
    profileAspect?: NovelAiAspect;
    situationPrompts?: SituationPrompt[];
}
export interface CharacterCard {
    name: string;
    description: string;
    customPrompt?: string;
    target: TargetAudience;
    audienceTier?: AudienceTier;
    isAdult?: boolean;
    profileImageUrl?: string;
    advancedImageSettings?: AdvancedImageSettings;
    specialType?: "card_builder";
    hashtags: string[];
    genreName?: GenreName;
    keywordNotes?: KeywordNote[];
    commandPresets?: CommandPreset[];
    startingSets: StartingSet[];
}
export interface CharacterDraftSeries {
    id: string;
    user_id: string;
    character_id?: string;
    title: string;
    description?: string;
    profile_image?: {
        origin?: string;
    };
    status: string;
    created_at: string;
    updated_at: string;
}
export interface CharacterDraftVersion {
    id: string;
    series_id: string;
    version_number: number;
    title: string;
    description?: string;
    payload: CharacterCard;
    created_at: string;
}
export interface RepresentativeCommentWriter {
    _id?: string;
    nickname?: string | null;
    profileImage?: string | null;
}
export interface RepresentativeComment {
    _id?: string;
    content?: string | null;
    created_at?: string | null;
    writer?: RepresentativeCommentWriter | null;
}
export interface PublicCharacterSummary {
    id: string;
    name?: string | null;
    description?: string | null;
    created_at: string;
    updated_at: string;
    visibility?: string | null;
    is_adult?: boolean | null;
    profileImage?: {
        origin?: string | null;
        gif?: string | null;
    } | null;
    tags?: string[] | null;
    startingSets?: PublicStartingSet[] | null;
    commandPresets?: CommandPreset[] | null;
    representativeComment?: RepresentativeComment | null;
}
