export const ARTIST_BUNDLE_PRESETS = [
    {
        id: "style1",
        name: "Painterly/Cinematic",
        description: "Painterly strokes + cinematic contrast. Drama/fantasy friendly.",
        tags: "[artist:wlop], 0.8::artist:toi8::, 0.6::artist:ask(askzy)::",
        weights: { "artist:toi8": 0.8, "artist:ask(askzy)": 0.6 },
        tone: "cinematic",
        usage: "general",
        model: "v4.5",
    },
    {
        id: "style2",
        name: "Sharp Anime Cleanline",
        description: "Crisp linework, modern anime finish. Portrait/clean UI.",
        tags: "[artist:toi8], [artist:kawacy], 0.6::artist:ciloranko::, 0.6::artist:blue gk::",
        weights: {
            "artist:ciloranko": 0.6,
            "artist:blue gk": 0.6,
        },
        tone: "sharp_clean",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style3",
        name: "Soft Pastel/Moe",
        description: "Pastel, soft rendering, moe vibe. Warm and gentle.",
        tags: "[artist:nompang], [artist:modare], 0.6::artist:kantoku::, 0.6::artist:kawacy::",
        tone: "soft_pastel",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style4",
        name: "Gritty Graphic",
        description: "Bold shapes, gritty texture, punchy contrast.",
        tags: "[artist:quasarcake], 0.8::artist:freng::, 0.6::artist:blue gk::",
        tone: "gritty",
        usage: "action",
        model: "v4.5",
    },
    {
        id: "style5",
        name: "Semi-Real Portrait",
        description: "Semi-realistic face focus; elegant detail.",
        tags: "0.9::artist:ask(askzy)::, [artist:toi8], 0.6::artist:blue gk::",
        tone: "semi_real",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style6",
        name: "Elegant Line + Glow",
        description: "Clean lines with subtle glow and delicacy.",
        tags: "[artist:kawacy], 0.8::artist:hintobento::, 0.6::artist:nompang::",
        tone: "elegant_glow",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style7",
        name: "Bold Drama Shapes",
        description: "Dramatic shape language, aggressive silhouette.",
        tags: "[artist:quasarcake], 0.8::artist:modare::, 0.6::artist:freng::",
        tone: "bold_drama",
        usage: "action",
        model: "v4.5",
    },
    {
        id: "style8",
        name: "Fantasy Illustration",
        description: "Fantasy‑leaning illustration with tasteful rendering.",
        tags: "[artist:nompang], 0.8::artist:toi8::, 0.6::artist:ciloranko::",
        tone: "fantasy_illust",
        usage: "general",
        model: "v4.5",
    },
    {
        id: "style9",
        name: "Moe Cleanline",
        description: "Clean moe‑style lineart with bright finish.",
        tags: "[artist:kantoku], 0.8::artist:kawacy::, 0.6::artist:nompang::",
        tone: "moe_clean",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style10",
        name: "Neon Glow",
        description: "Neon accents and glow‑heavy modern anime feel.",
        tags: "[artist:blue gk], 0.8::artist:toi8::, 0.6::artist:hintobento::",
        tone: "neon_glow",
        usage: "action",
        model: "v4.5",
    },
    {
        id: "style11",
        name: "Retro Print",
        description: "Slight retro print vibe, flat ink feeling.",
        tags: "[artist:ciloranko], 0.8::artist:modare::, 0.6::artist:quasarcake::",
        tone: "retro_print",
        usage: "general",
        model: "v4",
    },
    {
        id: "style12",
        name: "Noir Contrast",
        description: "Moody noir with strong rim and shadows.",
        tags: "[artist:freng], 0.8::artist:wlop::, 0.6::artist:toi8::",
        tone: "noir",
        usage: "action",
        model: "v4",
    },
    {
        id: "style13",
        name: "Warm Soft",
        description: "Warm, soft shading and gentle atmospherics.",
        tags: "[artist:nompang], 0.8::artist:kantoku::, 0.6::artist:hintobento::",
        tone: "warm_soft",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style14",
        name: "Cold Glass",
        description: "Cool palette and glassy highlights.",
        tags: "[artist:blue gk], 0.8::artist:ciloranko::, 0.6::artist:ask(askzy)::",
        tone: "cold_glass",
        usage: "general",
        model: "v4",
    },
    {
        id: "style15",
        name: "Paint + Glow",
        description: "Painterly base with modern glow polish.",
        tags: "[artist:wlop], 0.8::artist:hintobento::, 0.6::artist:nompang::",
        tone: "paint_glow",
        usage: "general",
        model: "v4.5",
    },
    {
        id: "style16",
        name: "Hyperline",
        description: "Ultra clean hyperline, crisp cel mix.",
        tags: "[artist:kawacy], 0.8::artist:toi8::, 0.6::artist:ciloranko::",
        tone: "hyperline",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style17",
        name: "Storybook",
        description: "Storybook feel with soft details.",
        tags: "[artist:modare], 0.8::artist:nompang::, 0.6::artist:kantoku::",
        tone: "storybook",
        usage: "general",
        model: "v4.5",
    },
    {
        id: "style18",
        name: "High Contrast",
        description: "Punchy high contrast, vivid edges.",
        tags: "[artist:freng], 0.8::artist:quasarcake::, 0.6::artist:blue gk::",
        tone: "high_contrast",
        usage: "action",
        model: "v4",
    },
    {
        id: "style19",
        name: "Flat Cell",
        description: "Flat cel finish with solid color fields.",
        tags: "[artist:ciloranko], 0.8::artist:kantoku::, 0.6::artist:kawacy::",
        tone: "flat_cell",
        usage: "portrait",
        model: "v4",
    },
    {
        id: "style20",
        name: "Idol Sheen",
        description: "Glossy idol‑style finish and sparkle.",
        tags: "[artist:kantoku], 0.8::artist:blue gk::, 0.6::artist:toi8::",
        tone: "idolsheen",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style21",
        name: "Arcane Lines",
        description: "Mystical lines with arcane flair.",
        tags: "[artist:modare], 0.8::artist:quasarcake::, 0.6::artist:kawacy::",
        tone: "bold_drama",
        usage: "general",
        model: "v4.5",
    },
    {
        id: "style22",
        name: "Steel & Glass",
        description: "Cool hard‑surface vibe, sleek anime tech.",
        tags: "[artist:blue gk], 0.8::artist:ciloranko::, 0.6::artist:freng::",
        tone: "sharp_clean",
        usage: "action",
        model: "v4",
    },
    {
        id: "style23",
        name: "Velvet Pastels",
        description: "Velvety pastel with soft diffusion.",
        tags: "[artist:nompang], 0.8::artist:hintobento::, 0.6::artist:kantoku::",
        tone: "soft_pastel",
        usage: "portrait",
        model: "v4.5",
    },
    {
        id: "style24",
        name: "Night City Glow",
        description: "Night neon city glow, sleek silhouettes.",
        tags: "[artist:blue gk], 0.8::artist:toi8::, 0.6::artist:freng::",
        tone: "neon_glow",
        usage: "action",
        model: "v4.5",
    },
];
export const QUALITY_BUNDLE_PRESETS = [
    {
        id: "q1",
        name: "Standard High",
        description: "Default high‑quality portrait/general.",
        tags: "year 2025, 1.8::masterpiece::, best quality, very aesthetic, highres, detailed face, eye highlights, soft rim light",
        usage: "general",
    },
    {
        id: "q2",
        name: "Cinematic",
        description: "Volumetric + dramatic shadows; filmic depth.",
        tags: "best quality, very aesthetic, highres, volumetric lighting, dramatic shadows, depth of field, cinematic lighting, tone mapping",
        usage: "action",
    },
    {
        id: "q3",
        name: "Action/Multi",
        description: "Motion emphasis for action/multi‑char.",
        tags: "best quality, dynamic lighting, sharp details, depth of field, motion emphasis, speed lines, motion blur",
        usage: "multi",
    },
    {
        id: "q4",
        name: "Soft Portrait",
        description: "Clean lines, soft lighting, skin focus.",
        tags: "best quality, clean lineart, crisp lines, soft lighting, subsurface scattering, skin shading, eye highlights",
        usage: "portrait",
    },
    {
        id: "q5",
        name: "Glow/Noir",
        description: "Moody rim/back lighting with bloom.",
        tags: "best quality, moody lighting, rim light, backlighting, bloom, fog, film grain:0.2",
        usage: "general",
    },
];
export function getArtistBundleByStyle(styleId) {
    return ARTIST_BUNDLE_PRESETS.find((b) => b.id === styleId);
}
export function filterBundles(params) {
    const { type = "all", query, tone, model, usage } = params || {};
    const match = (text) => !query || text.toLowerCase().includes(query.toLowerCase());
    const artistBundles = type === "quality"
        ? []
        : ARTIST_BUNDLE_PRESETS.filter((b) => {
            if (tone && tone !== "default" && b.tone !== tone)
                return false;
            if (model && b.model && b.model !== model)
                return false;
            if (usage && b.usage && b.usage !== usage)
                return false;
            return (match(b.name) || match(b.description) || match(b.tags) || match(b.id));
        });
    const qualityBundles = type === "artist"
        ? []
        : QUALITY_BUNDLE_PRESETS.filter((q) => {
            if (usage && q.usage && q.usage !== usage)
                return false;
            return match(q.name) || match(q.description) || match(q.tags) || match(q.id);
        });
    return { artistBundles, qualityBundles };
}
