export type ArtistBundle = {
    id: string;
    name: string;
    description: string;
    tags: string;
    weights?: Record<string, number>;
    tone?: "cinematic" | "sharp_clean" | "soft_pastel" | "gritty" | "semi_real" | "elegant_glow" | "bold_drama" | "fantasy_illust" | "moe_clean" | "neon_glow" | "retro_print" | "noir" | "warm_soft" | "cold_glass" | "paint_glow" | "hyperline" | "storybook" | "high_contrast" | "flat_cell" | "idolsheen";
    usage?: "portrait" | "action" | "multi" | "general";
    model?: "v4" | "v4.5";
};
export type QualityBundle = {
    id: string;
    name: string;
    description: string;
    tags: string;
    usage?: "portrait" | "action" | "multi" | "general";
};
export declare const ARTIST_BUNDLE_PRESETS: ArtistBundle[];
export declare const QUALITY_BUNDLE_PRESETS: QualityBundle[];
export declare function getArtistBundleByStyle(styleId: string): ArtistBundle | undefined;
export declare function filterBundles(params: {
    type?: "all" | "artist" | "quality";
    query?: string;
    tone?: ArtistBundle["tone"] | "default";
    model?: "v4" | "v4.5";
    usage?: ArtistBundle["usage"];
}): {
    artistBundles: ArtistBundle[];
    qualityBundles: QualityBundle[];
};
