import { callMcpApi } from "./httpClient.js";
/**
 * Create a new character draft (unregistered state)
 * Uses Edge Function to bypass RLS
 */
export async function createCharacterDraft(character) {
    const data = await callMcpApi("characters", {
        method: "POST",
        body: { character },
    });
    if (!data?.success) {
        throw new Error(data?.error || "Failed to create character");
    }
    return {
        seriesId: data.seriesId,
        versionId: data.versionId,
        message: data.message,
    };
}
/**
 * List user's character drafts
 * Uses Edge Function to bypass RLS
 */
export async function listCharacterDrafts(options) {
    const limit = options?.limit || 20;
    const offset = options?.offset || 0;
    const data = await callMcpApi("characters", {
        method: "GET",
        query: {
            limit,
            offset,
        },
    });
    if (!data?.success) {
        throw new Error(data?.error || "Failed to list characters");
    }
    return data.drafts || [];
}
/**
 * List public characters (published)
 */
export async function listPublicCharacters(options) {
    const limit = options?.limit || 20;
    const offset = options?.offset || 0;
    const detail = Boolean(options?.detail);
    const query = {
        limit,
        offset,
    };
    if (detail) {
        query.detail = "true";
    }
    const data = await callMcpApi("public-characters", {
        method: "GET",
        query,
    });
    if (!data?.success) {
        throw new Error(data?.error || "Failed to list public characters");
    }
    return data.characters || [];
}
/**
 * Get a specific character draft with its latest version
 * Uses Edge Function to bypass RLS
 */
export async function getCharacterDraft(seriesId) {
    const data = await callMcpApi(`characters/${seriesId}`, {
        method: "GET",
    });
    if (!data?.success) {
        throw new Error(data?.error || "Failed to get character");
    }
    return { series: data.series, version: data.version };
}
