import type { CharacterCard, CharacterDraftSeries, CharacterDraftVersion, PublicCharacterSummary } from "./types.js";
/**
 * Create a new character draft (unregistered state)
 * Uses Edge Function to bypass RLS
 */
export declare function createCharacterDraft(character: CharacterCard): Promise<{
    seriesId: string;
    versionId: string;
    message: string;
}>;
/**
 * List user's character drafts
 * Uses Edge Function to bypass RLS
 */
export declare function listCharacterDrafts(options?: {
    limit?: number;
    offset?: number;
}): Promise<CharacterDraftSeries[]>;
/**
 * List public characters (published)
 */
export declare function listPublicCharacters(options?: {
    limit?: number;
    offset?: number;
    detail?: boolean;
}): Promise<PublicCharacterSummary[]>;
/**
 * Get a specific character draft with its latest version
 * Uses Edge Function to bypass RLS
 */
export declare function getCharacterDraft(seriesId: string): Promise<{
    series: CharacterDraftSeries;
    version: CharacterDraftVersion;
}>;
