let cachedApiBaseUrl = null;
let cachedApiKey = null;
function normalizeBaseUrl(raw) {
    if (!raw) {
        throw new Error('환경 변수 MCP_API_BASE_URL이 설정되지 않았습니다. 예: https://ssalmukchat.com/api/mcp');
    }
    const trimmed = raw.trim();
    if (!trimmed) {
        throw new Error('환경 변수 MCP_API_BASE_URL이 비어 있습니다. 예: https://ssalmukchat.com/api/mcp');
    }
    return trimmed.endsWith('/') ? trimmed : `${trimmed}/`;
}
export function getApiBaseUrl() {
    if (cachedApiBaseUrl) {
        return cachedApiBaseUrl;
    }
    cachedApiBaseUrl = normalizeBaseUrl(process.env.MCP_API_BASE_URL ?? 'https://ssalmukchat.com/api/mcp');
    return cachedApiBaseUrl;
}
export function getMcpApiKey() {
    if (cachedApiKey) {
        return cachedApiKey;
    }
    const key = process.env.MCP_API_KEY?.trim();
    if (!key) {
        throw new Error('환경 변수 MCP_API_KEY가 설정되지 않았습니다. 쌀먹챗 앱에서 발급받은 MCP API 키를 설정해 주세요.');
    }
    cachedApiKey = key;
    return cachedApiKey;
}
