import { callMcpApi } from "./httpClient.js";
let authenticated = false;
let cachedUserId = null;
export function isAuthenticated() {
    return authenticated;
}
export function getUserId() {
    if (!cachedUserId) {
        throw new Error("API 키 검증이 완료되지 않았습니다.");
    }
    return cachedUserId;
}
export async function ensureApiKeyVerified() {
    if (authenticated) {
        return;
    }
    const data = await callMcpApi("verify-api-key", { method: "POST" });
    if (!data?.success) {
        throw new Error(data?.error || "API 키 검증에 실패했습니다.");
    }
    cachedUserId = data.userId;
    authenticated = true;
}
