# Ssalmuk Character MCP Server

Ssalmuk Character MCP 서버는 Claude Desktop에서 **캐릭터 초안**을 안전하게 만들고 조회할 수 있게 해 주는 공식 MCP 서버예요.  
쌀먹챗 앱에서 MCP API 키를 한 번만 발급해 두면, 로컬에서 편하게 캐릭터를 설계할 수 있어요.

## ✨ 주요 기능

- **Claude Desktop 연동 최적화**: `claude_desktop_config.json`에 바로 붙여 넣을 수 있는 예시 설정을 제공해요.
- **미등록 Draft 전용**: MCP로 만든 캐릭터는 모두 “미등록” 상태로 저장돼요. 수정/등록은 쌀먹챗 앱에서 진행해요.
- **단일 API 키 인증**: 쌀먹챗 앱 안에서 MCP API 키를 한 번만 발급해서 .env에 넣어 두면 돼요.

## ✅ 준비물

- Node.js **18.18+**
- npm **9+**
- 쌀먹챗 앱에서 발급한 MCP API 키 (`MY ▷ 고급 설정 ▷ MCP API 키`)
- Claude Desktop가 설치된 macOS / Windows / Linux 환경

## 🚀 빠르게 시작하기

```bash
git clone https://github.com/ssalmuk/ssalmuk-character-mcp.git
cd ssalmuk-character-mcp
npm install
cp .env.example .env               # 예시 파일을 복사해서 쓰면 편해요
npm run build
```

1. `.env` 파일에서 `MCP_API_KEY` 값을 쌀먹챗 앱에서 발급받은 실제 키로 바꿔 주세요.  
2. `claude_desktop_config.example.json` 내용을 참고해서 Claude 설정 파일에 MCP 서버를 등록해 주세요.
   - macOS: `~/Library/Application Support/Claude/claude_desktop_config.json`
   - Windows: `%APPDATA%/Claude/claude_desktop_config.json`
3. Claude Desktop을 완전히 종료 후 다시 실행하면, 서버가 자동으로 `verify-api-key`를 호출해서 키를 검증해요.

## ⚙️ 환경 변수 설정

| 변수 | 설명 | 기본값 |
| --- | --- | --- |
| `MCP_API_BASE_URL` | Ssalmuk MCP Edge API 엔드포인트 | `https://ssalmukchat.com/api/mcp` |
| `MCP_API_KEY` | 쌀먹챗 앱에서 발급한 MCP 전용 API 키 | _(필수)_ |

`claude_desktop_config.example.json` 파일에는 이미 `node` 명령과 `env` 블록이 들어 있어요.  
`/absolute/path/to/ssalmuk-character-mcp/build/index.js` 부분만 실제 경로로 바꾸고, `MCP_API_KEY` 값만 교체해서 사용하시면 돼요.

## 🧰 제공되는 MCP 도구

| 도구 이름 | 설명 | 주요 입력값 |
| --- | --- | --- |
| `character_create` | 새로운 캐릭터 카드 초안을 미등록 상태로 생성해요. | `name`, `description`, `startingSets` (필수). `customPrompt`, `hashtags`, `genreName`, `commandPresets`, `keywordNotes`, `advancedImageSettings` 등 선택. |
| `character_list` | 현재 계정의 미등록 캐릭터 목록을 조회해요. | `limit` (1–50, 기본 20), `offset` (0+) |
| `public_character_list` | 현재 계정의 공개 상태 캐릭터를 최신순으로 조회해요. | `limit` (1–50, 기본 20), `offset` (0+), `detail` (true면 상세 필드 포함) |
| `character_get` | 특정 시리즈의 최신 버전 캐릭터를 가져와요. | `seriesId` (필수) |

서버가 보내는 모든 요청에는 자동으로 다음 헤더가 들어가요.

- `Authorization: Bearer <MCP_API_KEY>`
- `User-Agent: SsalmukCharacterMCP/<version>`
- (부팅 시) `verify-api-key`를 통해 검증된 `userId`가 내부에 캐시돼요.

## 🏗️ 아키텍처 한눈에 보기

```
Claude Desktop
   │ (MCP)
   ▼
ssalmuk-character-mcp (Node.js, stdio)
   │ HTTPS + Bearer MCP key
   ▼
https://ssalmukchat.com/api/mcp  (Vercel Edge)
   │ Supabase service role (server-side only)
   ▼
Supabase character_draft_* tables
```

- 로컬 MCP 서버는 **HTTPS Edge API**만 호출하고, Supabase 서비스 키는 로컬로 내려오지 않아요.
- Draft는 사용자당 최대 30개, 버전은 시리즈당 최대 5개까지 유지돼요(실제 관리는 쌀먹챗 앱에서 해요).
- 더 자세한 내부 구조는 소스 코드(`src/`)를 참고해 주세요.

## 🧪 개발용 안내

```bash
npm run watch   # tsc --watch로 변경 사항을 실시간으로 빌드해요.
npm run build   # 프로덕션 빌드를 만들어요.
```

- TypeScript 선언 파일은 `build/` 디렉토리에 함께 출력돼요.
- `tsconfig.json`을 엄격하게 설정해 두어서, 타입 에러가 나면 빌드 단계에서 바로 확인할 수 있어요.

## ❗ 문제 해결하기

- **`API 키가 인증되지 않았습니다`**  
  `.env`에 입력된 키가 최신인지, 만료되지는 않았는지 확인해 주세요. 필요하면 새로 발급해서 교체해 주세요.
- **`Draft limit exceeded`**  
  미등록 Draft가 30개를 넘으면 더 만들 수 없어요. 쌀먹챗 앱에서 일부를 삭제하거나 등록해 주세요.
- **`Request failed with status 401`**  
  보통 Authorization 헤더가 빠졌을 때예요. Claude 설정 파일의 `env` 블록이 제대로 들어갔는지 확인해 주세요.
- **MCP 서버가 목록에 안 보여요**  
  설정 파일을 수정한 뒤 Claude Desktop을 완전히 종료(Cmd+Q / Alt+F4)하고 다시 실행해 주세요.
- 더 자세한 로그는 Claude Desktop의 MCP 서버 뷰에서 `ssalmuk-character` 항목을 선택해서 확인하실 수 있어요.

## 📄 라이선스

이 프로젝트는 [MIT License](./LICENSE)를 따르고 있어요.  
포크하거나 기여해 주실 때는 라이선스 문구를 그대로 유지해 주세요.
